import QtQuick 2.0

Item {
    property int scrollInterval : 400
    property int scrollDistance : 200
    property DragListView view
    property bool forward : true

    Timer {
        id : scrollTimer

        interval : scrollInterval
        repeat : true
        onTriggered : {
            if (!view)
                return;

            if (forward) {
                view.scrollForward(scrollDistance);
            } else {
                view.scrollBack(scrollDistance);
            }
        }
    }

    DropArea {
        z : 100
        anchors.fill : parent
        keys : "application/x-captivo-draggable"
        onEntered : scrollTimer.start()
        onExited : scrollTimer.stop()
        onDropped : scrollTimer.stop()
    }
}
